<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Badge;
use App\Models\General_Setting;
use App\Models\Common;
use Illuminate\Http\Request;
use Exception;

class BadgeSettingController extends Controller
{
    private $folder = "badge";
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index()
    {
        try {

            $params['setting_data'] = Setting_Data();
            $params['badge_data'] = Badge::get();

            $this->common->imageNameToUrl($params['badge_data'], 'image', $this->folder);

            return view('admin.badge_setting.index', $params);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function save(Request $request)
    {
        try {

            $data = $request->all();

            // Status
            $data['badge_status'] = $data['badge_status'] ?? 0;
            foreach ($data as $key => $value) {

                $setting = General_Setting::where('key', $key)->first();
                if (isset($setting['id'])) {
                    $setting['value'] = $value;
                    $setting->save();
                }
            }

            // Badge
            $badge_data = Badge::get();
            foreach ($badge_data as $badge) {
                $id = $badge['id'];

                $badge['label'] = $data["{$id}_label"] ?? '';
                $badge['description'] = $data["{$id}_description"] ?? '';
                if (isset($data["{$id}_image"])) {
                    $files = $data["{$id}_image"];
                    $badge->image = $this->common->saveImage($files, $this->folder, "badge_");

                    if (isset($data["{$id}_old_image"])) {
                        $this->common->deleteImageToFolder($this->folder, basename($data["{$id}_old_image"]));
                    }
                }
                $badge['earning_coin'] = $data["{$id}_earning_coin"] ?? 0;
                $badge['min_pass_quiz'] = $data["{$id}_min_pass_quiz"] ?? 0;
                $badge['min_win_contest'] = $data["{$id}_min_win_contest"] ?? 0;
                $badge['min_day_play'] = $data["{$id}_min_day_play"] ?? 0;
                $badge['min_coin_sharing'] = $data["{$id}_min_coin_sharing"] ?? 0;
                $badge['min_referrals'] = $data["{$id}_min_referrals"] ?? 0;
                $badge->save();
            }
            return response()->json(['status' => 200, 'success' => __('label.setting_save_successfully')]);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function status($id)
    {
        try {

            $data = Badge::where('id', $id)->first();
            if (isset($data)) {

                $data['status'] = $data['status'] === 1 ? 0 : 1;
                $data->save();
                return response()->json(['status' => 200, 'success' => __('label.status_changed'), 'status_code' => $data['status']]);
            } else {
                return response()->json(['status' => 400, 'errors' => __('label.data_not_found')]);
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
}
